<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class TrawlerLoggedVPCDestination extends \Google\Model
{
  /**
   * @var string
   */
  public $cloudRegion;
  protected $vnidType = NetFabricRpcVirtualNetworkId::class;
  protected $vnidDataType = '';
  public $vnid;

  /**
   * @param string
   */
  public function setCloudRegion($cloudRegion)
  {
    $this->cloudRegion = $cloudRegion;
  }
  /**
   * @return string
   */
  public function getCloudRegion()
  {
    return $this->cloudRegion;
  }
  /**
   * @param NetFabricRpcVirtualNetworkId
   */
  public function setVnid(NetFabricRpcVirtualNetworkId $vnid)
  {
    $this->vnid = $vnid;
  }
  /**
   * @return NetFabricRpcVirtualNetworkId
   */
  public function getVnid()
  {
    return $this->vnid;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TrawlerLoggedVPCDestination::class, 'Google_Service_Contentwarehouse_TrawlerLoggedVPCDestination');
